% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{setMask}
\alias{setMask}
\title{Set mask to only the probes specified}
\usage{
setMask(sdf, probes)
}
\arguments{
\item{sdf}{a \code{SigDF}}

\item{probes}{a vector of probe IDs or a logical vector with TRUE
representing masked probes}
}
\value{
a \code{SigDF} with added mask
}
\description{
Set mask to only the probes specified
}
\examples{
sdf <- sesameDataGet('EPIC.1.SigDF')
sum(sdf$mask)
sum(setMask(sdf, "cg14959801")$mask)
sum(setMask(sdf, c("cg14057072", "cg22344912"))$mask)
}
