% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{sesameQC_plotIntensVsBetas}
\alias{sesameQC_plotIntensVsBetas}
\title{Plot Total Signal Intensities vs Beta Values
This plot is helpful in revealing the extent of signal background
and dye bias.}
\usage{
sesameQC_plotIntensVsBetas(
  sdf,
  mask = TRUE,
  use_max = FALSE,
  intens.range = c(5, 15),
  pal = "whiteturbo",
  ...
)
}
\arguments{
\item{sdf}{a \code{SigDF}}

\item{mask}{whether to remove probes that are masked}

\item{use_max}{to use max(M,U) or M+U}

\item{intens.range}{plot range of signal intensity}

\item{pal}{color palette, whiteturbo, whiteblack, whitejet}

\item{...}{additional arguments to smoothScatter}
}
\value{
create a total signal intensity vs beta value plot
}
\description{
Plot Total Signal Intensities vs Beta Values
This plot is helpful in revealing the extent of signal background
and dye bias.
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
sesameQC_plotIntensVsBetas(sdf)
}
