% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesameAnno.R
\name{sesameAnno_buildManifestGRanges}
\alias{sesameAnno_buildManifestGRanges}
\title{Build manifest GRanges from tsv}
\usage{
sesameAnno_buildManifestGRanges(
  tsv,
  genome = NULL,
  decoy = FALSE,
  columns = NULL
)
}
\arguments{
\item{tsv}{a file path, a platform (e.g., EPIC), or
a tibble/data.frame object}

\item{genome}{a genome string, e.g., hg38, mm10}

\item{decoy}{consider decoy sequence in chromosome order}

\item{columns}{the columns to include in the GRanges}
}
\value{
GRanges
}
\description{
manifest tsv files can be downloaded from
http://zwdzwd.github.io/InfiniumAnnotation
}
\examples{
\dontrun{
tsv = sesameAnno_download("HM450.hg38.manifest.tsv.gz")
gr <- sesameAnno_buildManifestGRanges(tsv)
## direct access
gr <- sesameAnno_buildManifestGRanges("HM450.hg38.manifest")
}
}
