% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SigDFMethods.R
\name{sdf_read_table}
\alias{sdf_read_table}
\title{read a table file to SigDF}
\usage{
sdf_read_table(fname, platform = NULL, verbose = FALSE, ...)
}
\arguments{
\item{fname}{file name}

\item{platform}{array platform (will infer if not given)}

\item{verbose}{print more information}

\item{...}{additional argument to read.table}
}
\value{
read table file to SigDF
}
\description{
read a table file to SigDF
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
fname <- sprintf("\%s/sigdf.txt", tempdir())
sdf_write_table(sdf, file=fname)
sdf2 <- sdf_read_table(fname)
}
