% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{qualityMask}
\alias{qualityMask}
\title{Mask beta values by design quality}
\usage{
qualityMask(sdf, mask_names = "recommended", verbose = TRUE)
}
\arguments{
\item{sdf}{a \code{SigDF} object}

\item{mask_names}{a vector of masking groups, see listAvailableMasks
use "recommended" for recommended masking. One can also combine
"recommended" with other masking groups by specifying a vector, e.g.,
c("recommended", "M_mapping")}

\item{verbose}{be verbose}
}
\value{
a filtered \code{SigDF}
}
\description{
Currently quality masking only supports three platforms
see also listAvailableMasks(sdfPlatform(sdf))
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
sum(sdf$mask)
sum(qualityMask(sdf)$mask)
sum(qualityMask(sdf, mask_names = NULL)$mask)

## list available masks, the dbname column
listAvailableMasks(sdfPlatform(sdf))
listAvailableMasks("EPICv2")

}
