% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{predictAge}
\alias{predictAge}
\title{Predict age using linear models}
\usage{
predictAge(betas, model, na_fallback = FALSE, min_nonna = 10)
}
\arguments{
\item{betas}{a probeID-named vector of beta values}

\item{model}{a model object from sesameDataGet. should contain
param, intercept, response2age. default to the Horvath353 model.}

\item{na_fallback}{use fall back values if na}

\item{min_nonna}{the minimum number of non-NA values.}
}
\value{
age in the unit specified in the model (usually in year, but
sometimes can be month, like in the mouse clocks).
}
\description{
The function takes a named numeric vector of beta values. The name attribute
contains the probe ID (cg, ch or rs IDs). The function looks for overlapping
probes and estimate age using different models.
}
\details{
You can get the models such as the Horvath aging model (Horvath 2013
Genome Biology) from sesameDataGet. The function outputs a single numeric
of age in years.

Here are some built-in age models:
Anno/HM450/Clock_Horvath353.rds
Anno/HM450/Clock_Hannum.rds
Anno/HM450/Clock_SkinBlood.rds
Anno/EPIC/Clock_PhenoAge.rds
Anno/MM285/Clock_Zhou347.rds
see vignette inferences.html#Age__Epigenetic_Clock for details
}
\examples{
betas <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
\dontrun{
## download age models from
## https://github.com/zhou-lab/InfiniumAnnotationV1/tree/main/Anno
## e.g., Anno/HM450/Clock_Horvath353.rds
predictAge(betas, model)
}
}
