% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open.R
\name{openSesame}
\alias{openSesame}
\title{The openSesame pipeline}
\usage{
openSesame(
  x,
  prep = "QCDPB",
  prep_args = NULL,
  manifest = NULL,
  func = getBetas,
  BPPARAM = SerialParam(),
  platform = "",
  min_beads = 1,
  ...
)
}
\arguments{
\item{x}{SigDF(s), IDAT prefix(es)}

\item{prep}{preprocessing code, see ?prepSesame}

\item{prep_args}{optional preprocessing argument list, see ?prepSesame}

\item{manifest}{optional dynamic manifest}

\item{func}{either getBetas or getAFs, if NULL, then return SigDF list}

\item{BPPARAM}{get parallel with MulticoreParam(n)}

\item{platform}{optional platform string}

\item{min_beads}{minimum bead number, probes with R or G smaller than
this threshold will be masked. If NULL, no filtering based on bead
count will be applied. Default to 1.}

\item{...}{parameters to getBetas}
}
\value{
a numeric vector for processed beta values
}
\description{
This function is a simple wrapper of noob + nonlinear dye bias 
correction + pOOBAH masking.
}
\details{
Please use mask=FALSE to turn off masking.

If the input is an IDAT prefix or a \code{SigDF}, the output is
the beta value numerics.
}
\examples{

in_dir <- system.file("extdata", "", package = "sesameData")
betas <- openSesame(in_dir)
## or
IDATprefixes <- searchIDATprefixes(in_dir)
betas <- openSesame(IDATprefixes)

}
