% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileSet.R
\name{mapFileSet}
\alias{mapFileSet}
\title{Deposit data of one sample to a fileSet (and hence to file)}
\usage{
mapFileSet(fset, sample, named_values)
}
\arguments{
\item{fset}{a sesame::fileSet, as obtained via readFileSet}

\item{sample}{sample name as a string}

\item{named_values}{value vector named by probes}
}
\value{
a sesame::fileSet
}
\description{
Deposit data of one sample to a fileSet (and hence to file)
}
\examples{

## create two samples
fset <- initFileSet('mybetas2', 'HM27', c('s1','s2'))

## a hypothetical numeric array (can be beta values, intensities etc)
hypothetical <- setNames(runif(fset$n), fset$probes)

## map the numeric to file
mapFileSet(fset, 's1', hypothetical)

## get data
sliceFileSet(fset, 's1', 'cg00000292')

}
