% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strain.R
\name{inferStrain}
\alias{inferStrain}
\title{Infer strain information for mouse array}
\usage{
inferStrain(
  sdf,
  return.strain = FALSE,
  return.probability = FALSE,
  return.pval = FALSE,
  min_frac_dt = 0.2,
  verbose = FALSE
)
}
\arguments{
\item{sdf}{SigDF}

\item{return.strain}{return strain name}

\item{return.probability}{return probability vector for all strains}

\item{return.pval}{return p-value}

\item{min_frac_dt}{minimum fraction of detected signal (DEFAULT: 0.2)
otherwise, we give up strain inference and return NA.}

\item{verbose}{print more messages}
}
\value{
a list of best guess, p-value of the best guess
and the probabilities of all strains
}
\description{
Infer strain information for mouse array
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('MM285.1.SigDF')
inferStrain(sdf, return.strain = TRUE)
sdf.strain <- inferStrain(sdf)
}
