% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{imputeBetasByGenomicNeighbors}
\alias{imputeBetasByGenomicNeighbors}
\title{Impute missing data based on genomic neighbors.}
\usage{
imputeBetasByGenomicNeighbors(
  betas,
  platform = NULL,
  BPPARAM = SerialParam(),
  max_neighbors = 3,
  max_dist = 10000
)
}
\arguments{
\item{betas}{named vector of beta values}

\item{platform}{platform}

\item{BPPARAM}{use MulticoreParam(n) for parallel processing}

\item{max_neighbors}{maximum neighbors to use for dense regions}

\item{max_dist}{maximum distance to count as neighbor}
}
\value{
imputed data, vector or matrix
}
\description{
Impute missing data based on genomic neighbors.
}
\examples{
betas = openSesame(sesameDataGet("EPICv2.8.SigDF")[[1]])
sum(is.na(betas))
betas2 = imputeBetasByGenomicNeighbors(betas, "EPICv2")
sum(is.na(betas2))

}
