% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dye_bias.R
\name{dyeBiasL}
\alias{dyeBiasL}
\title{Correct dye bias in by linear scaling.}
\usage{
dyeBiasL(sdf, ref = NULL)
}
\arguments{
\item{sdf}{a \code{SigDF}}

\item{ref}{reference signal level}
}
\value{
a normalized \code{SigDF}
}
\description{
The function takes a \code{SigDF} as input and scale both the Grn and Red
signal to a reference (ref) level. If the reference level is not given, it
is set to the mean intensity of all the in-band signals. The function
returns a \code{SigDF} with dye bias corrected.
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
sdf.db <- dyeBiasL(sdf)
}
