% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesame.R
\name{chipAddressToSignal}
\alias{chipAddressToSignal}
\title{Lookup address in one sample}
\usage{
chipAddressToSignal(dm, mft, min_beads = NULL)
}
\arguments{
\item{dm}{data frame in chip address, 2 columns: cy3/Grn and cy5/Red}

\item{mft}{a data frame with columns Probe_ID, M, U and col}

\item{min_beads}{minimum bead counts, otherwise masked}
}
\value{
a SigDF, indexed by probe ID address
}
\description{
Lookup address and transform address to probe
}
\details{
Translate data in chip address to probe address.
Type I probes can be separated into Red and Grn channels. The
methylated allele and unmethylated allele are at different
addresses. For type II probes methylation allele and unmethylated allele are
at the same address. Grn channel is for methylated allele and Red channel is
for unmethylated allele. The out-of-band signals are type I probes measured
using the other channel.
}
