% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection.R
\name{ELBAR}
\alias{ELBAR}
\title{ELiminate BAckground-dominated Reading (ELBAR)}
\usage{
ELBAR(
  sdf,
  return.pval = FALSE,
  pval.threshold = 0.05,
  margin = 0.05,
  capMU = 3000,
  delta.beta = 0.2,
  n.windows = 500
)
}
\arguments{
\item{sdf}{a \code{SigDF}}

\item{return.pval}{whether to return p-values, instead of a SigDF}

\item{pval.threshold}{minimum p-value to mask}

\item{margin}{the percentile margin to define envelope, the smaller
the value the more aggressive the masking.}

\item{capMU}{the maximum M+U to search for intermediate betas}

\item{delta.beta}{maximum beta value change from
sheer background-dominated readings}

\item{n.windows}{number of windows for smoothing}
}
\value{
a \code{SigDF} with mask added
}
\description{
ELiminate BAckground-dominated Reading (ELBAR)
}
\examples{
sdf <- sesameDataGet("EPIC.1.SigDF")
sum(sdf$mask)
sum(ELBAR(sdf)$mask)
}
