% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualizeRegion}
\alias{visualizeRegion}
\title{Visualize Region}
\usage{
visualizeRegion(
  chrm,
  beg,
  end,
  betas,
  platform = NULL,
  genome = NULL,
  draw = TRUE,
  cluster.samples = FALSE,
  na.rm = FALSE,
  nprobes.max = 1000,
  txn.types = "protein_coding",
  txn.font.size = 6,
  ...
)
}
\arguments{
\item{chrm}{chromosome}

\item{beg}{begin of the region}

\item{end}{end of the region}

\item{betas}{beta value matrix (row: probes, column: samples)}

\item{platform}{EPIC, HM450, or MM285}

\item{genome}{hg38, mm10, ..., will infer if not given.
For additional mapping, download the GRanges object from
http://zwdzwd.github.io/InfiniumAnnotation
and provide the following argument
..., genome = sesameAnno_buildManifestGRanges("downloaded_file"),...
to this function.}

\item{draw}{draw figure or return betas}

\item{cluster.samples}{whether to cluster samples}

\item{na.rm}{remove probes with all NA.}

\item{nprobes.max}{maximum number of probes to plot}

\item{txn.types}{default to protein_coding, use NULL for all}

\item{txn.font.size}{transcript name font size}

\item{...}{additional options, see assemble_plots}
}
\value{
graphics or a matrix containing the captured beta values
}
\description{
The function takes a genomic coordinate (chromosome, start and end) and a
beta value matrix (probes on the row and samples on the column). It plots
the beta values as a heatmap for all probes falling into the genomic region.
If `draw=TRUE` the function returns the plotted grid graphics object.
Otherwise, the selected beta value matrix is returned.
`cluster.samples=TRUE/FALSE` controls whether hierarchical clustering is
applied to the subset beta value matrix.
}
\examples{
betas <- sesameDataGet('HM450.76.TCGA.matched')$betas
visualizeRegion('chr20', 44648623, 44652152, betas, 'HM450')
}
