% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesame.R
\name{probeSuccessRate}
\alias{probeSuccessRate}
\title{Whole-dataset-wide Probe Success Rate}
\usage{
probeSuccessRate(sdf, mask = TRUE, max_pval = 0.05)
}
\arguments{
\item{sdf}{a \code{SigDF}}

\item{mask}{whether or not we count the masked probes in SigDF}

\item{max_pval}{the maximum p-value to consider detection success}
}
\value{
a fraction number as probe success rate
}
\description{
This function calculates the probe success rate using
pOOBAH detection p-values. Probes that has a detection p-value
higher than a specific threshold are considered failed probes.
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
probeSuccessRate(sdf)
}
