% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{DMR}
\alias{DMR}
\title{Find Differentially Methylated Region (DMR)}
\usage{
DMR(
  betas,
  smry,
  contrast,
  platform = NULL,
  probe.coords = NULL,
  dist.cutoff = NULL,
  seg.per.locus = 0.5
)
}
\arguments{
\item{betas}{beta values for distance calculation}

\item{smry}{DML}

\item{contrast}{the pair-wise comparison or contrast
check colnames(attr(smry, "model.matrix")) if uncertain}

\item{platform}{EPIC, HM450, MM285, ...}

\item{probe.coords}{GRanges object that defines CG coordinates
if NULL (default), then the default genome assembly is used.
Default genome is given by, e.g., sesameData_check_genome(NULL, "EPIC")
For additional mapping, download the GRanges object from
http://zwdzwd.github.io/InfiniumAnnotation
and provide the following argument
..., probe.coords = sesameAnno_buildManifestGRanges("downloaded_file"),...
to this function.}

\item{dist.cutoff}{cutoff of beta value differences for two neighboring CGs
to be considered the same DMR (by default it's determined using the
quantile function on seg.per.locus)}

\item{seg.per.locus}{number of segments per locus
higher value leads to more segments}
}
\value{
coefficient table with segment ID and segment P-value
each row is a locus, multiple loci may share a segment ID if
they are merged to the same segment. Records are ordered by Seg_Est.
}
\description{
This subroutine uses Euclidean distance to group CpGs and
then combine p-values for each segment. The function performs DML test first
if cf is NULL. It groups the probe testing results into differential
methylated regions in a coefficient table with additional columns
designating the segment ID and statistical significance (P-value) testing
the segment.
}
\examples{

sesameDataCache() # in case not done yet

data <- sesameDataGet('HM450.76.TCGA.matched')
smry <- DML(data$betas[1:1000,], ~type, meta=data$sampleInfo)
colnames(attr(smry, "model.matrix")) # pick a contrast from here
## showing on a small set of 100 CGs
merged_segs <- DMR(data$betas[1:1000,], smry, "typeTumour", platform="HM450")

sesameDataGet_resetEnv()

}
