% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_signal.R
\name{quantileGRangesWidth}
\alias{quantileGRangesWidth}
\title{Quantile width determination strategy}
\usage{
quantileGRangesWidth(qgr, min_quantile = 0.75, win_size = 1)
}
\arguments{
\item{qgr}{GRanges to calculate quantile width for}

\item{min_quantile}{numeric value from 0 to 1. The minimum quantile of width in qgr}

\item{win_size}{numeric/integer >=1, returned value will be a multiple of
this}
}
\value{
numeric that is >= min_quantile and evenly divisible by win_size
}
\description{
Returns the lowest multiple of win_size greater than
min_quantile quantile of width(qgr)
}
\examples{
data(CTCF_in_10a_overlaps_gr)
gr = CTCF_in_10a_overlaps_gr
quantileGRangesWidth(gr)
quantileGRangesWidth(gr, min_quantile = .5, win_size = 100)
}
