% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_bam.R
\name{expandCigar}
\alias{expandCigar}
\title{Expand cigar codes to GRanges}
\usage{
expandCigar(
  cigar_dt,
  op_2count = c("M", "D", "=", "X"),
  return_data.table = FALSE
)
}
\arguments{
\item{cigar_dt}{data.table with 5 required named columns in any order.
c("which_label", "seqnames", "strand", "start", "cigar")}

\item{op_2count}{Cigar codes to count. Default is alignment (M), deletion
(D), match (=), and mismatch (X).  Other useful codes may be skipped
regions for RNA splicing (N).  The locations of any insterions (I) or
clipping/padding (S, H, or P) will be a single bp immediately before the
interval.}

\item{return_data.table}{if TRUE, a data.table is returned, else a GRanges.
Default is FALSE.}
}
\value{
data.table with cigar entries expanded
}
\description{
see \href{https://samtools.github.io/hts-specs/SAMv1.pdf}{sam specs} for
cigar details
}
\examples{
data(CTCF_in_10a_overlaps_gr)
qgr = CTCF_in_10a_overlaps_gr[1:5]
bam_file = system.file("extdata/test.bam", package = "seqsetvis", mustWork = TRUE)
raw_dt = ssvFetchBam(bam_file, qgr, return_unprocessed = TRUE)
expandCigar(raw_dt)
}
