% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fw_hotspot.R
\name{fw_hotspot}
\alias{fw_hotspot}
\title{forward amplicon ranking}
\usage{
fw_hotspot(bins, data, amp, len, include_genes)
}
\arguments{
\item{bins}{A dataframe containing all potential amplicons}

\item{data}{A dataframe containing the location of each mutation.}

\item{amp}{The length of amplicons in number of base pairs}

\item{len}{The total length of sequencing panel in number of base pairs}

\item{include_genes}{True or False based on whether dataset includes gene names}
}
\value{
A dataframe containing the genomic coordinates for targeted sequencing panel
}
\description{
create a targeted sequencing panel by finding which amplicons
will likely capture the most mutations
}
\details{
Forward Selection Sequencing Panel Identifier

1.	Amplicons covering hotspots less than or equal to one amplicon in length,
are added to the final sequencing panel dataset.

2.	For amplicons covering larger hotspot regions, the algorithm uses a
forward selection method to determine the optimal combination of amplicons
to use in the sequencing panel:
  a.	the algorithm first identifies the amplicon containing the highest
  number of mutations
  b.	the algorithm then identifies the next amplicon, which contains the
  highest number of new mutations.
  c.	this process continues until all mutations are covered by at least
  one amplicon

3.	Each of these amplicons are then added to the final sequencing panel,
with their own unique IDs.

4.	All amplicons in the final sequencing panel are ranked from highest to
lowest based on the number of mutations they cover.

5.	The algorithm then calculates the cumulative base-pair length and the
cumulative mutations covered by each amplicon.

6.	Dependent on the desired length of the targeted panel, a cutoff may be
applied to remove all amplicons which fall below a set cumulative length.
}
\examples{

data("mutation_data")
my_bins <- amp_pool(mutation_data, 100)

fw_hotspot(my_bins, mutation_data, 100, 1000, TRUE)

}
