% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_scoreMarkers.R
\name{scoreMarkers.se}
\alias{scoreMarkers.se}
\alias{formatScoreMarkersResult}
\alias{previewMarkers}
\title{Score marker genes in a SummarizedExperiment}
\usage{
scoreMarkers.se(
  x,
  groups,
  block = NULL,
  num.threads = 1,
  more.marker.args = list(),
  assay.type = "logcounts",
  extra.columns = NULL,
  order.by = TRUE
)

formatScoreMarkersResult(marker.res, extra.columns = NULL, order.by = TRUE)

previewMarkers(
  marker.df,
  columns = c("mean", "detected", lfc = "delta.mean.mean"),
  pre.columns = NULL,
  post.columns = NULL,
  rows = 10,
  order.by = NULL,
  include.order.by = !is.null(order.by)
)
}
\arguments{
\item{x}{A \link[SummarizedExperiment]{SummarizedExperiment} object or one of its subclasses.
Rows correspond to genes and columns correspond to cells.}

\item{groups}{Group assignment for each cell, passed to \code{\link{scoreMarkers}}.}

\item{block}{Block assignment for each cell, passed to \code{\link{scoreMarkers}}.}

\item{num.threads}{Number of threads for marker scoring, passed to \code{\link{scoreMarkers}}.}

\item{more.marker.args}{Named list of additional arguments to pass to \code{\link{scoreMarkers}}.}

\item{assay.type}{Integer or string specifying the assay to use for differential comparisons, usually containing log-normalized expression values.}

\item{extra.columns}{\link[S4Vectors]{DataFrame} containing extra columns to add each DataFrame.
This should have the same number of rows as \code{x}.
For \code{scoreMarkers.se}, this may also be a character vector specifying the columns of \code{\link[SummarizedExperiment]{rowData}} to be added.}

\item{order.by}{String specifying the column to order each DataFrame by.
Alternatively \code{TRUE}, a column is automatically chosen from the effect size summaries.
If \code{NULL} or \code{FALSE}, no ordering is performed.}

\item{marker.res}{List containing the result of \code{\link{scoreMarkers}}.}

\item{marker.df}{DataFrame containing the marker statistics for a single group.}

\item{columns}{Character vector of the names of columns to retain in the preview.
This may be named, in which the names are used as the column names.}

\item{pre.columns, post.columns}{Character vector of the names of additional columns to retain in the preview.
These are added before or after the columns in \code{columns}, for \code{pre.columns} and \code{post.columns} respectively.}

\item{rows}{Integer specifying the number of rows to show.
If \code{NULL}, all rows are returned.}

\item{include.order.by}{Boolean indicating whether the column specified by \code{order.by} should be included in the output DataFrame.
A string may also be supplied and will be treated as \code{TRUE}; the value of the string will be used as the column name in the output DataFrame.}
}
\value{
For \code{scoreMarkers.se} and \code{formatScoreMarkersResult}, a \link[S4Vectors]{List} of \link[S4Vectors]{DataFrame}s is returned.
Each DataFrame corresponds to a unique group in \code{groups}.
Each row contains statistics for a gene in \code{x}, with the following columns:
\itemize{
\item \code{mean}, the mean expression in the current group.
\item \code{detected}, the proportion of cells with detected expression in the current group.
\item \code{<effect>.<summary>}, a summary statistic for an effect size,
e.g., \code{cohens.d.mean} contains the mean Cohen's d across comparisons involving the current group.
}

For \code{previewMarkers}, a DataFrame is returned containing the specified columns and rows.
}
\description{
Identify candidate marker genes based on effect sizes from pairwise comparisons between groups of cells,
by calling \code{\link{scoreMarkers}} on an assay of a \link[SummarizedExperiment]{SummarizedExperiment}.
}
\examples{
sce <- getTestRnaData.se("cluster")
markers <- scoreMarkers.se(sce, sce$clusters)
previewMarkers(markers[["1"]])

}
\author{
Aaron Lun
}
