% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_scaleByNeighbors.R
\name{scaleByNeighbors.se}
\alias{scaleByNeighbors.se}
\title{Scale and combine multiple embeddings in a SingleCellExperiment}
\usage{
scaleByNeighbors.se(
  x,
  altexp.reddims,
  main.reddims = "PCA",
  num.neighbors = 20,
  block = NULL,
  BNPARAM = AnnoyParam(),
  num.threads = 1,
  more.scale.args = list(),
  output.name = "combined",
  meta.name = "combined",
  delayed.transpose = FALSE
)
}
\arguments{
\item{x}{A \link[SingleCellExperiment]{SingleCellExperiment} object or one of its subclasses.
Rows correspond to genomic features and columns correspond to cells.}

\item{altexp.reddims}{Named list of character or integer vectors.
Each entry is named after an alternative experiment.
Each vector contains the names/indices of the \code{\link[SingleCellExperiment]{reducedDim}} embeddings from that experiment to be combined.}

\item{main.reddims}{Character or integer vector specifying the names/indices of the \code{\link[SingleCellExperiment]{reducedDim}} entries from \code{x} to be combined.}

\item{num.neighbors}{Number of neighbors used to define the scaling factor, passed to \code{\link{scaleByNeighbors}}.}

\item{block}{Block assignment for each cell, passed to \code{\link{scaleByNeighbors}}.}

\item{BNPARAM}{Algorithm for the nearest neighbor search, passed to \code{\link{scaleByNeighbors}}.}

\item{num.threads}{Number of threads for the neighbor search, passed to \code{\link{scaleByNeighbors}}.}

\item{more.scale.args}{Named list of additional arguments to pass to \code{\link[scrapper]{scaleByNeighbors}}.}

\item{output.name}{String containing the name of the \code{\link[SingleCellExperiment]{reducedDim}} entry in which to store the combined embeddings.}

\item{meta.name}{String containing the name of the \code{\link[S4Vectors]{metadata}} entry in which to store additional metrics.
If \code{NULL}, additional metrics are not stored.}

\item{delayed.transpose}{Logical scalar indicating whether to delay the transposition when storing coordinates in the \code{\link[SingleCellExperiment]{reducedDims}}.}
}
\value{
\code{x} is returned with the combined embeddings stored in its \code{rowData}.
The scaling factors for all embeddings are stored in the \code{metadata}.
}
\description{
Scale embeddings for different modalities to equalize their intra-population variance, and combine them into a single embedding for downstream analysis.
This calls \code{\link{scaleByNeighbors}} on the reduced dimensions of the main/alternative experiments in a \link[SingleCellExperiment]{SingleCellExperiment}.
}
\examples{
library(SingleCellExperiment)
sce <- getTestAdtData.se("pca")
sce <- scaleByNeighbors.se(sce, altexp.reddims=list(ADT="PCA"))
reducedDimNames(sce) 
metadata(sce)$combined

}
\author{
Aaron Lun
}
