% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_runUmap.R
\name{runUmap.se}
\alias{runUmap.se}
\title{UMAP on a SummarizedExperiment}
\usage{
runUmap.se(
  x,
  num.dim = 2,
  min.dist = 0.1,
  num.neighbors = 15,
  num.threads = 1,
  more.umap.args = list(),
  reddim.type = "PCA",
  output.name = "UMAP"
)
}
\arguments{
\item{x}{A \link[SingleCellExperiment]{SingleCellExperiment} object or one of its subclasses.
Rows correspond to genomic features and columns correspond to cells.}

\item{num.dim}{Number of dimensions in the output embedding, passed to \code{\link{runUmap}}.}

\item{min.dist}{Minimum distance between observations, passed to \code{\link{runUmap}}.}

\item{num.neighbors}{Number of neighbors for constructing the fuzzy sets, passed to \code{\link{runUmap}}.}

\item{num.threads}{Number of threads for the UMAP, passed to \code{\link{runUmap}}.}

\item{more.umap.args}{Named list of further arguments to pass to \code{\link[scrapper]{runUmap}}.}

\item{reddim.type}{Integer or string specifying the existing embedding in the \code{\link[SingleCellExperiment]{reducedDim}} of \code{x}.
Alternatively, a named integer or character vector of length 1,
where the name specifies an alternative experiment of \code{x} and the value is the name/index of a \code{reducedDim} entry in that alternative experiment.}

\item{output.name}{String containing the name of the output \code{\link[SingleCellExperiment]{reducedDim}}.}
}
\value{
\code{x} is returned with the UMAP coordinates stored in the \code{reducedDim}.
}
\description{
Generate a UMAP visualization from an existing embedding,
by calling \code{\link{runUmap}} on a reduced dimension entry in \link[SingleCellExperiment]{SingleCellExperiment}.
}
\examples{
library(SingleCellExperiment)
sce <- getTestRnaData.se("pca")
# Using fewer epochs for a faster-running example.
sce <- runUmap.se(sce, more.umap.args=list(num.epochs=50))
head(reducedDim(sce, "UMAP"))
 
}
\author{
Aaron Lun
}
