% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_correctMnn.R
\name{correctMnn.se}
\alias{correctMnn.se}
\title{MNN correction on a SingleCellExperiment}
\usage{
correctMnn.se(
  x,
  block,
  BNPARAM = AnnoyParam(),
  num.threads = 1,
  more.mnn.args = list(),
  reddim.type = "PCA",
  output.name = "MNN",
  delayed.transpose = FALSE
)
}
\arguments{
\item{x}{A \link[SingleCellExperiment]{SingleCellExperiment} object or one of its subclasses.
Rows correspond to genomic features and columns correspond to cells.}

\item{block}{Block assignment for each cell, passed to \code{\link{correctMnn}}.}

\item{BNPARAM}{Algorithm for the nearest neighbor search, passed to \code{\link{correctMnn}}.}

\item{num.threads}{Number of threads, passed to \code{\link{correctMnn}}.}

\item{more.mnn.args}{Named list of additional arguments to pass to \code{\link{correctMnn}}.}

\item{reddim.type}{String or integer specifying the \code{\link[SingleCellExperiment]{reducedDim}} entry on which to perform MNN correction.
Alternatively, a named integer or character vector of length 1,
where the name specifies an alternative experiment of \code{x} and the value is the name/index of a \code{reducedDim} entry in that alternative experiment.}

\item{output.name}{String containing the name of the \code{\link[SingleCellExperiment]{reducedDim}} entry in which to store the corrected embedding.}

\item{delayed.transpose}{Logical scalar indicating whether to delay the transposition when storing coordinates in the \code{\link[SingleCellExperiment]{reducedDims}}.}
}
\value{
\code{x} is returned with the corrected embedding stored as a \code{reducedDim} entry.
}
\description{
Correct batch effects from an existing embedding with mutual nearest neighbors (MNNs),
by calling \code{\link{correctMnn}} on a reduced dimension entry of a \link[SingleCellExperiment]{SingleCellExperiment}.
}
\examples{
library(SingleCellExperiment)
sce <- getTestRnaData.se("pca")
# Treating the tissue of origin as the batch.
sce <- correctMnn.se(sce, sce$tissue)
reducedDimNames(sce)

}
\author{
Aaron Lun
}
