% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormalizedMatrix.R
\name{LogNormalizedMatrix}
\alias{LogNormalizedMatrix}
\alias{LogNormalizedMatrix-class}
\alias{LogNormalizedMatrixSeed-class}
\alias{dim,LogNormalizedMatrixSeed-method}
\alias{dimnames,LogNormalizedMatrixSeed-method}
\alias{type,LogNormalizedMatrixSeed-method}
\alias{is_sparse,LogNormalizedMatrixSeed-method}
\alias{extract_array,LogNormalizedMatrixSeed-method}
\alias{extract_sparse_array,LogNormalizedMatrixSeed-method}
\alias{matrixClass,LogNormalizedMatrixSeed-method}
\alias{DelayedArray,LogNormalizedMatrixSeed-method}
\alias{initializeCpp,LogNormalizedMatrixSeed-method}
\alias{LogNormalizedMatrixSeed}
\title{Delayed log-normalization of a matrix}
\usage{
LogNormalizedMatrix(x, size.factors, pseudo.count = 1, log.base = 2)

LogNormalizedMatrixSeed(x, size.factors, pseudo.count = 1, log.base = 2)
}
\arguments{
\item{x}{Count matrix to be normalized.}

\item{size.factors}{Numeric vector of size factors, of length equal to the number of columns of \code{x}.}

\item{pseudo.count}{Number specifying the pseudo-count to add prior to log-transformation.}

\item{log.base}{Number specifying the base of the log-transformation.}
}
\value{
An instance of a LogNormalizedMatrix(Seed).
}
\description{
Delayed calculation of log-normalized expression values, typically returned by \code{\link{normalizeCounts}}.
}
\details{
This is based on the \pkg{DelayedArray} framework and
}
\examples{
mat <- matrix(rpois(1000, lambda=2), ncol=10)
sf <- centerSizeFactors(colSums(mat))
norm <- LogNormalizedMatrix(mat, sf)
norm

# Also works with sparse matrices.
library(Matrix)
smat <- abs(rsparsematrix(50, 20, density=0.21))
ssf <- centerSizeFactors(colSums(smat))
snorm <- LogNormalizedMatrix(smat, ssf)
snorm

}
\author{
Aaron Lun
}
