% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbiasPlot.R
\name{mbiasplot}
\alias{mbiasplot}
\title{Methylation bias plot}
\usage{
mbiasplot(dir = NULL, mbiasFiles = NULL)
}
\arguments{
\item{dir}{directory name with mbias files}

\item{mbiasFiles}{list of mbias files}
}
\value{
Returns a list containing the methylation across the read position in original top
and original bottom strand both in forward and reverse reads for multiple samples
}
\description{
Plot the methylation at each position of the read to observe any biases in
the methylation
based on the read position
}
\examples{
mbiasFile <- '2017-04-21_HG23KBCXY_2_AGGCAGAA_TATCTC_pe.M-bias.txt'
mbiasplot(mbiasFiles=system.file("extdata", mbiasFile, package='scmeth'))
}
