% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsample.R
\name{downsample}
\alias{downsample}
\title{Downsample analysis}
\usage{
downsample(bs, dsRates = c(0.01, 0.02, 0.05, seq(0.1, 0.9, 0.1)),
  subSample = 1e+06, offset = 50000)
}
\arguments{
\item{bs}{bsseq object}

\item{dsRates}{downsampling rate. i.e. the probabaility of sampling
a single CpG
default is list of probabilities ranging from 0.01 to 1
0.01 0.02 0.05 0.10 0.20 0.30 0.40 0.50 0.60 0.70 0.80 0.90
For more continuous saturation curve dsRates can be changed to add more
sampling rates}

\item{subSample}{number of CpGs to subsample
Default value is 1000000.}

\item{offset}{how many CpGs to offset when subsampling
Default value is set to be 50000, i.e. first 50000 CpGs will
be ignored in subsampling.}
}
\value{
Data frame with the CpG coverage for each sample at each
sampling rate
}
\description{
Downsample the CpG coverage matrix for saturation analysis
}
\examples{
directory <- system.file("extdata/bismark_data", package='scmeth')
bs <- HDF5Array::loadHDF5SummarizedExperiment(directory)
scmeth::downsample(bs)
}
