% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{NN}
\alias{NN}
\title{Main nearest neighbour calculation function. Used on the first reference dataset.
Returns a list of three objects:
1) the cell indices of the w nearest neighbours
2) the corresponding approx. cosine similarities}
\usage{
NN(w, k, subcentroids, subclusters, query_chunks, M, SqNorm)
}
\arguments{
\item{w}{An integer specifying the number of nearest neighbours}

\item{k}{An integer specifying the number of subcentroids for each product quantization chunk}

\item{subcentroids}{A list of matrices containing the subcentroids of each chunk.}

\item{subclusters}{A matrix containing the subcentroid assignments of each reference cell. See scf_index.}

\item{query_chunks}{A list of matrices containing the chunks of the query dataset after it has been split
according to the product quantization method}

\item{M}{An integer specifying the number of chunks}

\item{SqNorm}{A numerical vector containing the Euclidean Squared Norm of each query cell.}
}
\description{
Main nearest neighbour calculation function. Used on the first reference dataset.
Returns a list of three objects:
1) the cell indices of the w nearest neighbours
2) the corresponding approx. cosine similarities
}
