% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCellCompo.R
\name{plotCellCompo}
\alias{plotCellCompo}
\title{Plot cell type composition in each density level of cell of interest.}
\usage{
plotCellCompo(
  spe,
  contour = NULL,
  id = "cell_type",
  roi = NULL,
  self.included = TRUE
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{contour}{A character vector of cell type(s) on which the
contour density level is calculated. If NULL, it looks for
'overall_contour' in colData(spe). Default to NULL.}

\item{id}{A character. The name of the column of colData(spe)
containing the cell type identifiers. Set to 'cell_type' by default.}

\item{roi}{Character. The name of the group or cell type on which
the roi is computed. Default is NULL for no plotting by ROI}

\item{self.included}{Logical. Whether to include all the cell types in the plot.
Default to TRUE. If FALSE, the cell types specified in 'contour' will not
be included in the plot.}
}
\value{
A ggplot object.
}
\description{
Plot cell type composition in each density level of cell of interest.
}
\examples{

data("xenium_bc_spe")
coi <- "Breast cancer"
spe <- gridDensity(spe, coi = coi)
spe <- findROI(spe, coi = coi)
spe <- getContour(spe, coi = coi)
spe <- allocateCells(spe, contour = coi)
plotCellCompo(spe, contour = "Breast cancer")
plotCellCompo(spe, contour = "Breast cancer", roi = coi)

}
