% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findNbrsGrid.R
\name{findNbrsGrid}
\alias{findNbrsGrid}
\title{Construct a neighbour list from grid coordinates.}
\usage{
findNbrsGrid(
  spe,
  n = 1,
  radius = NULL,
  diagonal = FALSE,
  dist_func = c("idw", "exp", "binary", "none"),
  dist_type = c("euclidean", "manhattan"),
  standardisation = c("row", "none"),
  scale = 1,
  nbrs_name = NULL,
  cpu_threads = 6
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{n}{Integer. Search for neighbours within (...). Either the number of
neighbors or radius}

\item{radius}{Numeric. Search for neighbours within the radius.}

\item{diagonal}{Whether to consider diagonal connection if using square grid}

\item{dist_func}{Options for distance-based weight. "idw" for inverse
distance, "exp" for exponential decay, "binary" for constant weight, and
"raw" for raw distance.}

\item{dist_type}{Options of using euclidean or manhattan for distance calculation}

\item{standardisation}{Options for weight standardisation. "none" for
nothing, and "row" for dividing weights by number of neighbours.}

\item{scale}{Numeric scaler for weight scaling.}

\item{nbrs_name}{Name of the neighbour list to be stored. Default to be "grid".}

\item{cpu_threads}{Number of cpu threads for parallel computation.}
}
\value{
A SpatialExperiment object with neighbour list stored in
\code{spe@metadata$nbrs$grid[[nbrs_name]]}
}
\description{
Construct a neighbour list from grid coordinates.
}
\details{
If n is used, distance is scaled to unit distance
}
\examples{

data("xenium_bc_spe")
spe <- gridDensity(spe)
spe <- findNbrsGrid(spe,n=3)
}
