% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hexbin_meta_plus.R
\name{plot_hexbin_meta_plus}
\alias{plot_hexbin_meta_plus}
\title{Plot of meta data with annotation of single cell data in
   bivariate hexagon cells.}
\usage{
plot_hexbin_meta_plus(
  sce,
  col1,
  col2,
  action,
  no = 1,
  colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  expand_hull = 3,
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{sce}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object.}

\item{col1}{A string referring to the name of one column in the meta data of
sce by which to make the outlines. Note that this should be a factor or
a character.}

\item{col2}{A string referring to the name of one column in the meta data of
sce specifying what to color hexagons by.}

\item{action}{A string specifying how meta data as specified in col2 of
observations in binned  hexagon cells are to be summarized. Possible
actions are \code{prop}, \code{mode}, \code{mean} and \code{median}
(see details).}

\item{no}{An integer specifying which level to plot of the column. Only in
effect when \code{action=prop}.}

\item{colors}{A vector of strings specifying which colors to use for plotting
the different levels in the selected column of the meta data.}

\item{title}{A string containing the title of the plot.}

\item{xlab}{A string containing the title of the x axis.}

\item{ylab}{A string containing the title of the y axis.}

\item{expand_hull}{A numeric value determining the expansion of the line
marking different clusters.}

\item{na.rm}{Logical indicating whether NA values should be removed.}

\item{...}{Additional arguments passed on to
\code{\link{ggforce}{geom_mark_hull}}.}
}
\value{
A \code{\link{ggplot2}{ggplot}} object.
}
\description{
Plot of meta data with annotation of single cell data in
   bivariate hexagon cells.
}
\details{
This function plots any meta data in the hexagon cell
  representation calculated with \code{\link{make_hexbin}} as well as at the
  same time representing outlines of clusters. The chosen gene
  expression is summarized by one of four actions \code{prop_0},
  \code{mode}, \code{mean} and \code{median}:

  \describe{
    \item{\code{prop}}{Returns the proportion of each level or unique
     character in the bin. The associated meta data column needs to be a
     factor or character.}
    \item{\code{mode}}{Returns the mode of the observations in the bin. The
     associated meta data column needs to be numeric.}
    \item{\code{mean}}{Returns the mean of the observations in the bin. The
     associated meta data column needs to be numeric.}
     \item{\code{median}}{Returns the median of the observations in the bin.
     The associated meta data column needs to be numeric.}
  }
}
\examples{
# For SingleCellExperiment object
library(TENxPBMCData)
library(scater)
tenx_pbmc3k <- TENxPBMCData(dataset = "pbmc3k")
rm_ind <- calculateAverage(tenx_pbmc3k) < 0.1
tenx_pbmc3k <- tenx_pbmc3k[-rm_ind, ]
colData(tenx_pbmc3k) <- cbind(colData(tenx_pbmc3k), perCellQCMetrics(tenx_pbmc3k))
tenx_pbmc3k <- logNormCounts(tenx_pbmc3k)
tenx_pbmc3k <- runPCA(tenx_pbmc3k)
tenx_pbmc3k <- make_hexbin(tenx_pbmc3k, 20, dimension_reduction = "PCA")
tenx_pbmc3k$random <- factor(sample(1:3, ncol(tenx_pbmc3k), replace = TRUE))
tenx_pbmc3k$random <- as.factor(tenx_pbmc3k$random)
plot_hexbin_meta_plus(tenx_pbmc3k, col1 = "random", col2 = "total", action = "median")
}
