% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{viewTargetAlignment}
\alias{viewTargetAlignment}
\title{viewTargetAlignment}
\usage{
viewTargetAlignment(
  m,
  miRNA,
  seqs = NULL,
  flagBulgeMatches = FALSE,
  p3.params = list(),
  min3pMatch = 3L,
  hideSingletons = FALSE,
  UGsub = TRUE,
  ...,
  outputType = c("print", "data.frame", "plot", "ggplot")
)
}
\arguments{
\item{m}{A GRanges of length 1 giving the information for a given match, as
produced by \code{\link{findSeedMatches}}.}

\item{miRNA}{A miRNA sequence, or a \code{\link{KdModel}} object of the miRNA
corresponding to the match in `m`; alternatively, a \code{\link{KdModelList}}
including the model.}

\item{seqs}{The sequences corresponding to the seqnames of `m`. Not needed if
`m` contains the target sequences.}

\item{flagBulgeMatches}{Logical; whether to flag matches inside the bulge
(default FALSE)}

\item{p3.params}{See \code{\link{findSeedMatches}}.}

\item{min3pMatch}{The minimum 3' alignment for any to be plotted}

\item{hideSingletons}{Logical; whether to hide isolated single base-pair
matches}

\item{UGsub}{Logical; whether to show U-G matches}

\item{...}{Passed to `text` if `outputType="plot"`.}

\item{outputType}{Either 'print' (default, prints to console), 'data.frame',
or 'plot'.}
}
\value{
Returns nothing `outputType="print"`. If `outputType="data.frame"`,
returns a data.frame containing the alignment strings; if
`outputType="ggplot"` returns a `ggplot` object.
}
\description{
viewTargetAlignment
}
\examples{
data(SampleKdModel)
seq <- c(seq1="CGACCCCTATCACGTCCGCAGCATTAAAT")
m <- findSeedMatches(seq, SampleKdModel, verbose=FALSE)
viewTargetAlignment(m, miRNA=SampleKdModel, seqs=seq)
}
