% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{aggregateMatches}
\alias{aggregateMatches}
\title{aggregateMatches}
\usage{
aggregateMatches(
  m,
  a = 0.007726,
  b = 0.5735,
  c = 0.181,
  p3 = 0.051,
  coef_utr = 0,
  coef_orf = 0,
  p3.range = c(3L, 8L),
  keepSiteInfo = TRUE,
  toInt = FALSE,
  BP = NULL
)
}
\arguments{
\item{m}{A GRanges or data.frame of matches as returned by `findSeedMatches`.}

\item{a}{The relative concentration of unbound AGO-miRNA complexes.}

\item{b}{Factor specifying the additional repression by a single bound AGO.}

\item{c}{Penalty for sites that are found within the ORF region.}

\item{p3}{Factor specifying additional repression due to 3p alignment.}

\item{coef_utr}{Factor specifying additional repression due to UTR length.}

\item{coef_orf}{Factor specifying additional repression due to ORF length.}

\item{p3.range}{Range used for 3p alignment.}

\item{keepSiteInfo}{Logical; whether to return information about site types
(default = TRUE). Ignored if `m` does not contain `log_kd` values}

\item{toInt}{Logical; whether to convert repression scores to integers
(default = FALSE).}

\item{BP}{Pass `BiocParallel::MulticoreParam(ncores, progressbar=TRUE)` to
enable multithreading. Note that in addition, `aggregateMatches` uses the
\link{data.table} package, which is often set to use multi-threading by
default (which would be multiplied by threads determined by `BP`). See
\code{\link[data.table]{setDTthreads}} for more information.}
}
\value{
a data.frame containing aggregated repression values and/or
information about the numbers and types of matches
}
\description{
Aggregates miRNA binding sites with log_kd values to predict transcript
repression. See the vignette for more detail.
}
\examples{
# we create mock RNA sequences and seeds:
seqs <- getRandomSeq(n=10)

# load sample KdModel
data(SampleKdModel)

# find matches
matches <- findSeedMatches(seqs, SampleKdModel)

# aggregate matches
aggregateMatches(matches)
}
