% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLogPlot.R
\name{logLogPlot}
\alias{logLogPlot}
\title{Plot a log-log plot for read counts}
\usage{
logLogPlot(sce)
}
\arguments{
\item{sce}{A SingleCellExperiment object that contains read count data to be
plotted. The read counts are extracted from an associated h5 file or similar
data structure within the object.}
}
\value{
A ggplot object representing the log-log plot of read counts.
}
\description{
This function generates a log-log plot of read counts using the data from a
`SingleCellExperiment` object.
}
\examples{
# Assume `sce` is a SingleCellExperiment object with a 'counts' assay
h5_file_path <- system.file("extdata", "demo.h5", package = "scafari")
h5 <- h5ToSce(h5_file_path)
sce <- h5$sce_amp
plot <- logLogPlot(sce)
print(plot)

}
