% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startTreeViz.R
\name{startTreeviz}
\alias{startTreeviz}
\title{Start treeviz app and create \code{\link[scTreeViz]{TreeVizApp}} object to manage connection.}
\usage{
startTreeviz(
  data = NULL,
  genes = NULL,
  top_genes = 100,
  host = "http://epiviz.cbcb.umd.edu/treeviz",
  register_function = .register_all_treeviz_things,
  delay = 2L,
  ...
)
}
\arguments{
\item{data}{TreeViz object to explore}

\item{genes}{(character vector) genes (rownames) to include in heatmap}

\item{top_genes}{(integer) number of top variable genes to include in the heatmap}

\item{host}{(character) host address to launch.}

\item{register_function}{(function) function used to register actions and charts on the treeviz app.}

\item{delay}{(integer) number of seconds to wait for application to load in browser}

\item{...}{additional parameters passed to \code{\link[epivizr]{startEpiviz}}.}
}
\value{
An object of class \code{\link[scTreeViz]{TreeVizApp}}
}
\description{
Start treeviz app and create \code{\link[scTreeViz]{TreeVizApp}} object to manage connection.
}
\examples{
# see package vignette for example usage
app <- startTreeviz(non_interactive=TRUE, open_browser=FALSE)
app$stop_app()

}
\seealso{
\code{\link[scTreeViz]{TreeVizApp}}
}
