% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APPconf-methods.R
\name{APPconf-methods}
\alias{APPconf-methods}
\alias{show,APPconf-method}
\alias{$,APPconf-method}
\alias{$<-,APPconf-method}
\alias{[[,APPconf,ANY,ANY-method}
\alias{[[<-,APPconf,ANY,ANY,ANY-method}
\alias{[,APPconf,ANY,ANY,ANY-method}
\alias{as.list,APPconf-method}
\alias{as.character,APPconf-method}
\alias{markers,APPconf-method}
\alias{markers}
\alias{lapply,APPconf-method}
\alias{unlist,APPconf-method}
\title{The methods for \link{APPconf-class}}
\usage{
\S4method{show}{APPconf}(object)

\S4method{$}{APPconf}(x, name)

\S4method{$}{APPconf}(x, name) <- value

\S4method{[[}{APPconf,ANY,ANY}(x, i, j, ..., exact = TRUE)

\S4method{[[}{APPconf,ANY,ANY,ANY}(x, i, j, ...) <- value

\S4method{[}{APPconf,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{as.list}{APPconf}(x, ...)

\S4method{as.character}{APPconf}(x, ...)

\S4method{markers}{APPconf}(x)

\S4method{lapply}{APPconf}(X, FUN, ...)

\S4method{unlist}{APPconf}(x, recursive = TRUE, use.names = TRUE)
}
\arguments{
\item{object}{an object of APPconf}

\item{x}{APPconf object.}

\item{name}{A literal character string or a name (possibly backtick quoted).}

\item{value}{value to replace.}

\item{i, j}{indices specifying elements to extract or replace.}

\item{\dots}{Named or unnamed arguments to form a signature.}

\item{exact}{see \link[base]{Extract}}

\item{drop}{see \link[base]{drop}}

\item{X}{an APPconf object.}

\item{FUN}{function used by \code{lapply}}

\item{recursive, use.names}{function used by \link[base:unlist]{unlist}}
}
\value{
A named character vector.
}
\description{
The assessment and replacement methods for \link{APPconf-class}
}
\examples{
appconf <- readRDS(system.file("extdata", "data",
    "pbmc_small", "appconf.rds", package="scRNAseqApp"))
appconf
appconf$title
appconf[["title"]]
as.list(appconf)
as.character(appconf)
markers(appconf)
lapply(appconf, print)
unlist(appconf)
}
\concept{APPconf}
