% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_out_score_glm_null.R
\name{stat_out_score_glm_null}
\alias{stat_out_score_glm_null}
\title{Calculate part of the score statistic for a GLM.}
\usage{
stat_out_score_glm_null(Y = NULL, B_null = NULL)
}
\arguments{
\item{Y}{: The response variable Defaults to NULL.}

\item{B_null}{: Design matrix under the null model. Defaults to NULL.}
}
\value{
A list of values (mainly products of matrices) that make up the 
final score statistic calculation (required for another function).
}
\description{
A function that calculates parts of the score statistic for 
GLMs only (it is used for the full path for forward selection).
}
\references{
Stoklosa, J., Gibb, H. and Warton, D.I. (2014). Fast forward 
selection for generalized estimating equations with a large number of 
predictor variables. \emph{Biometrics}, \strong{70}, 110--120.

Stoklosa, J. and Warton, D.I. (2018). A generalized estimating 
equation approach to multivariate adaptive regression splines. 
\emph{Journal of Computational and Graphical Statistics}, 
\strong{27}, 245--253.
}
\seealso{
\code{\link{stat_out}}

\code{\link{stat_out_score_gee_null}}
}
\author{
Jakub Stoklosa

David I. Warton

Jack R. Leary
}
