% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_out.R
\name{stat_out}
\alias{stat_out}
\title{Fits a linear regression model and calculates RSS/GCV measures (used for 
MARS linear models).}
\usage{
stat_out(Y = NULL, B1 = NULL, TSS = NULL, GCV.null = NULL, pen = 2)
}
\arguments{
\item{Y}{The response variable. Defaults to NULL.}

\item{B1}{The model matrix of predictor variables. Defaults to NULL.}

\item{TSS}{Total sum of squares. Defaults to NULL.}

\item{GCV.null}{GCV value for the intercept model. Defaults to NULL.}

\item{pen}{The set/fixed penalty used for the GCV. Defaults to 2.}
}
\value{
A list consisting of the RSS, RSSq1, GCV1 and GCVq1 values for the 
fitted model.
}
\description{
Calculate the final RSS / GCV for a fitted model.
}
\references{
Friedman, J. (1991). Multivariate adaptive regression splines. 
\emph{The Annals of Statistics}, \strong{19}, 1--67.

Stoklosa, J. and Warton, D.I. (2018). A generalized estimating 
equation approach to multivariate adaptive regression splines. 
\emph{Journal of Computational and Graphical Statistics}, 
\strong{27}, 245--253.
}
\seealso{
\code{\link{stat_out_score_glm_null}}
}
\author{
Jakub Stoklosa

David I. Warton

Jack R. Leary
}
