% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFittedValues.R
\name{getFittedValues}
\alias{getFittedValues}
\title{Generate a table of fitted values and celltype metadata for genes of interest.}
\usage{
getFittedValues(
  test.dyn.res = NULL,
  genes = NULL,
  pt = NULL,
  expr.mat = NULL,
  size.factor.offset = NULL,
  log1p.norm = TRUE,
  cell.meta.data = NULL,
  is.gee = FALSE,
  id.vec = NULL,
  ci.alpha = 0.05,
  filter.lineage = NULL
)
}
\arguments{
\item{test.dyn.res}{The output from \code{\link{testDynamic}}. Defaults 
to NULL.}

\item{genes}{A character vector of genes to generate fitted values for. 
Defaults to NULL.}

\item{pt}{A data.frame of pseudotime values for each cell. Defaults to NULL.}

\item{expr.mat}{Either a \code{SingleCellExperiment}, \code{Seurat}, or 
\code{cell_data_set} object from which counts can be extracted, or a matrix 
of integer-valued counts with genes as rows & cells as columns. Defaults 
to NULL.}

\item{size.factor.offset}{(Optional) An offset to be used to rescale the 
fitted values. Can be generated easily with \code{\link{createCellOffset}}. 
No need to provide if the GEE backend was used. Defaults to NULL.}

\item{log1p.norm}{(Optional) Should log1p-normalized versions of expression 
& model predictions be returned as well? Defaults to TRUE.}

\item{cell.meta.data}{(Optional) A data.frame of metadata values for each 
cell (celltype label, subject characteristics, tissue type, etc.) that will 
be included in the result table. Defaults to NULL.}

\item{is.gee}{Was the GEE mode used to fit the models? Defaults to FALSE.}

\item{id.vec}{(Optional) A vector of subject IDs used in fitting GEE or 
GLMM models. Defaults to NULL.}

\item{ci.alpha}{(Optional) The pre-specified Type I Error rate used in 
generating (\eqn{1 - \alpha})\% CIs. Defaults to good old 0.05.}

\item{filter.lineage}{(Optional) A character vector of lineages to filter 
out. Should be letters, i.e. lineage "A" or "B". Defaults to NULL.}
}
\value{
A data.frame containing depth- and log1p-normalized expression, 
model predictions, and cell-level metadata.
}
\description{
Generate a table of expression counts, model fitted values, 
celltype metadata, etc. in order to create custom plots of gene dynamics.
}
\examples{
data(sim_counts)
data(sim_pseudotime)
data(scLANE_models)
fitted_vals <- getFittedValues(scLANE_models,
    genes = sample(names(scLANE_models), 5),
    pt = sim_pseudotime,
    expr.mat = sim_counts
)
}
\author{
Jack R. Leary
}
