% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selgene.R
\name{selgene}
\alias{selgene}
\title{Select Top Expressed Genes from Single-Cell Data}
\usage{
selgene(
  object,
  top_n,
  cell_type = NULL,
  cell_type_col = "cell_type",
  assay = NULL,
  remove_mt = FALSE,
  remove_rib = FALSE
)
}
\arguments{
\item{object}{A Seurat object, SingleCellExperiment object, or numeric
matrix (genes × cells).}

\item{top_n}{Integer. Number of top expressed genes to return.}

\item{cell_type}{Optional string. If provided, filters the expression
matrix to only include cells of this type.}

\item{cell_type_col}{Character. Name of the column in metadata (Seurat
\code{meta.data} or SCE \code{colData}) containing cell type annotations.
Default is \code{"cell_type"}.}

\item{assay}{Character. For SingleCellExperiment objects only. Name of the
assay to use. If \code{NULL}, defaults to \code{"logcounts"}.}

\item{remove_mt}{Logical. If \code{TRUE}, remove mitochondrial genes matching
\code{"^MT-"} (case-insensitive).}

\item{remove_rib}{Logical. If \code{TRUE}, remove ribosomal genes matching
\code{"^RP[SL]"} (case-insensitive).}
}
\value{
A character vector of the top \code{n} most highly expressed gene
names.
}
\description{
Identifies and returns the top \code{n} most highly expressed genes across
all cells or within a specific cell type. Supports objects of class
Seurat, \linkS4class{SingleCellExperiment}, or a numeric
expression matrix (genes × cells).
}
\details{
The function assumes that log-normalized values are available in the
\code{"data"} slot (for Seurat objects) or the \code{"logcounts"} assay
(for SingleCellExperiment). If raw counts are provided as a matrix, no
transformation is applied.

Optional filtering is available to exclude mitochondrial genes
(\code{"^MT-"}) and ribosomal genes (\code{"^RP[SL]"}), which may otherwise
dominate the top expressed genes.
}
\section{Details}{

When using a Seurat object, the function retrieves the log-normalized data
from the default assay's \code{"data"} slot. For SingleCellExperiment, it
uses the specified assay (default is \code{"logcounts"}). For matrices, no
checks or transformations are applied, and subsetting by cell type is not
supported.

Mitochondrial and ribosomal gene removal is based on regular expressions
matching gene names. These should follow standard naming conventions (e.g.,
\code{MT-ND1}, \code{RPL13A}, \code{RPS6}).
}

\examples{

data(toy_counts)
genes <- selgene(
    object = toy_counts[[1]],
    top_n = 5,
    cell_type = "T_cells",
    cell_type_col = "CELL_TYPE",
    remove_rib = TRUE,
    remove_mt = TRUE,
    assay = "counts"
)
}
\seealso{
\linkS4class{SingleCellExperiment}
}
