% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mae.R
\name{create_mae}
\alias{create_mae}
\title{Create MultiAssayExperiment from Multiple Single-Cell Datasets}
\usage{
create_mae(datasets, colData = NULL, ...)
}
\arguments{
\item{datasets}{A named list of datasets. Each element can be:
\itemize{
\item A matrix (genes × cells)
\item A Seurat object
\item A SingleCellExperiment object
}}

\item{colData}{Optional. A DataFrame with metadata for each experiment.
If NULL, automatically generated from list names.}

\item{...}{Additional arguments (currently unused)}
}
\value{
A MultiAssayExperiment object with:
\itemize{
\item experiments: List of SingleCellExperiment objects
\item colData: Metadata for each experiment/condition
}
}
\description{
Converts a list of count matrices, Seurat objects, or SingleCellExperiment
objects into a MultiAssayExperiment for integrated network inference.
}
\examples{
# Load the example MAE
data("toy_counts")

# Extract the list of SingleCellExperiment objects
sce_list <- MultiAssayExperiment::experiments(toy_counts)
sce_list <- as.list(sce_list)

# Create a new MAE from the SCE list
mae <- create_mae(sce_list)
mae
}
