% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_scfeatures.R
\name{run_pathway_mean}
\alias{run_pathway_mean}
\title{Generate pathway score using expression level}
\usage{
run_pathway_mean(
  data,
  geneset = NULL,
  species = "Homo sapiens",
  type = "scrna",
  ncores = 1
)
}
\arguments{
\item{data}{A list object containing \code{data} matrix and \code{celltype} and \code{sample} vector.}

\item{geneset}{By default (when the \code{geneset} argument is not specified),
we use the 50 hallmark gene set from msigdb.
The users can also provide their geneset of interest in a list format, with
each list entry containing a vector of the names of genes in a gene set.
eg, geneset <- list("pathway_a" = c("CANS1", ...), "pathway_b" = c("PEX6"))}

\item{species}{Whether the species is "Homo sapiens" or "Mus musculus".
Default is "Homo sapiens".}

\item{type}{The type of dataset, either "scrna", "spatial_t", or "spatial_p".}

\item{ncores}{Number of cores for parallel processing.}
}
\value{
a dataframe of samples x features
The features are in the form of pathway 1 celltype a, pathway 2 celltype b ...
etc, with the number representing the averaged expression of a given pathway in
cells from a given celltype.
}
\description{
This function calculates pathway scores for a given dataset and gene set
using gene expression levels. It supports scRNA-seq, spatial transcriptomics
and spatial proteomics and spatial transcriptomics).
By default, it uses the 50 hallmark gene sets from msigdb.
Alternatively, users can provide their own gene sets of interest in a list format.
}
\examples{

utils::data("example_scrnaseq" , package = "scFeatures")
data <- example_scrnaseq[1:500, 1:200]
celltype <- data$celltype
sample <- data$sample
data <- data@assays$RNA@data

alldata <- scFeatures:::formatData(data = data, celltype = celltype, sample = sample )
 feature_pathway_mean <- run_pathway_mean(
    alldata ,
    geneset = NULL, species = "Homo sapiens",
    type = "scrna", ncores = 1
 )


}
