% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_scfeatures.R
\name{run_nn_correlation}
\alias{run_nn_correlation}
\title{Generate nearest neighbour correlation}
\usage{
run_nn_correlation(data, type = "spatial_p", num_top_gene = NULL, ncores = 1)
}
\arguments{
\item{data}{A list object containing \code{data} matrix and \code{celltype} and \code{sample} vector.}

\item{type}{The type of dataset, either "scrna", "spatial_t", or "spatial_p".}

\item{num_top_gene}{Number of top variable genes to use when genes is
not provided. Defaults to 1500.}

\item{ncores}{Number of cores for parallel processing.}
}
\value{
a dataframe of samples x features
The features are in the form of protein 1, protein 2 ... etc, with the numbers
representing Pearson's correlation.
}
\description{
This function calculates the nearest neighbour correlation for each feature
(eg, proteins) in each sample. This is calculated by taking the correlation
between each cell and its nearest neighbours cell for a particular feature.
This function supports spatial proteomics, and spatial transcriptomics.
}
\examples{

utils::data("example_scrnaseq" , package = "scFeatures")
data <- example_scrnaseq[1:50, 1:20]
celltype <- data$celltype 
data <- data@assays$RNA@data
sample <- sample( c("patient1", "patient2", "patient3"), ncol(data) , replace= TRUE )
x <- sample(1:100, ncol(data) , replace = TRUE)
y <- sample(1:100, ncol(data) , replace = TRUE)
spatialCoords <- list( x , y)
alldata <- scFeatures:::formatData(data = data, sample = sample, celltype = celltype, 
spatialCoords  = spatialCoords )
feature_nn_correlation <- run_nn_correlation(
    alldata, type = "spatial_p", ncores = 1
)

}
