% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_scfeatures.R
\name{run_gene_mean}
\alias{run_gene_mean}
\title{Generate overall aggregated mean expression}
\usage{
run_gene_mean(
  data,
  type = "scrna",
  genes = NULL,
  num_top_gene = NULL,
  ncores = 1
)
}
\arguments{
\item{data}{A list object containing \code{data} matrix and \code{celltype} and \code{sample} vector.}

\item{type}{The type of dataset, either "scrna", "spatial_t", or "spatial_p".}

\item{genes}{Default to NULL, in which case the top variable genes will be
used. If provided by user, need to be in the format of a list containing the
genes of interest, eg, genes <- c(GZMA", "GZMK", "CCR7", "RPL38" )}

\item{num_top_gene}{Number of top variable genes to use when genes is not provided.
Defaults to 1500.}

\item{ncores}{Number of cores for parallel processing.}
}
\value{
a dataframe of samples x features
The features are in the form of gene 1, gene 2 ... etc, with the numbers representing
averaged gene expression across all cells.
}
\description{
This function computes the mean expression of genes across samples. The user
can specify the genes of interest, or let the function use the top variable
genes by default. The function supports scRNA-seq, spatial proteomics,
and spatial transcriptomics.
}
\examples{

utils::data("example_scrnaseq" , package = "scFeatures")
data <- example_scrnaseq
celltype <- data$celltype
sample <- data$sample
data <- data@assays$RNA@data

alldata <- scFeatures:::formatData(data = data, celltype = celltype, sample = sample )
feature_gene_mean <- run_gene_mean(
    alldata,
    type = "scrna", num_top_gene = 150, ncores = 1
)

}
