% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_scfeatures.R
\name{run_celltype_interaction}
\alias{run_celltype_interaction}
\title{Generate cell type interaction}
\usage{
run_celltype_interaction(data, type = "spatial_p", ncores = 1)
}
\arguments{
\item{data}{A list object containing \code{data} matrix and \code{celltype} and \code{sample} vector.}

\item{type}{The type of dataset, either "scrna", "spatial_t", or "spatial_p".}

\item{ncores}{Number of cores for parallel processing.}
}
\value{
a dataframe of samples x features
The features are in the form of protein 1 vs protein 2, protein 1 vs protein 3 ...
etc, with the numbers representing the proportion of each interaction pairs in a
give sample.
}
\description{
This function calculates the pairwise distance between cell types
for a sample by using the coordinates and cell types of the cells.
We find the nearest neighbours of each cell and the cell types of these neighbours.
These are considered as spatial interaction pairs. The cell type composition of the
spatial interaction pairs are used as features.
The function supports spatial proteomics and spatial transcriptomics.
}
\examples{

utils::data("example_scrnaseq" , package = "scFeatures")
data <- example_scrnaseq[1:50, 1:20]
celltype <- data$celltype 
data <- data@assays$RNA@data
sample <- sample( c("patient1", "patient2", "patient3"), ncol(data) , replace= TRUE )
x <- sample(1:100, ncol(data) , replace = TRUE)
y <- sample(1:100, ncol(data) , replace = TRUE)
spatialCoords <- list( x , y)
alldata <- scFeatures:::formatData(data = data, sample = sample, celltype = celltype, 
spatialCoords  = spatialCoords )

feature_celltype_interaction <- run_celltype_interaction(
    alldata, type = "spatial_p", ncores = 1
)

}
