% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_scfeatures.R
\name{run_L_function}
\alias{run_L_function}
\title{Generate L stats}
\usage{
run_L_function(data, type = "spatial_p", ncores = 1)
}
\arguments{
\item{data}{A list object containing \code{data} matrix and \code{celltype} and \code{sample} vector.}

\item{type}{The type of dataset, either "scrna", "spatial_t", or "spatial_p".}

\item{ncores}{Number of cores for parallel processing.}
}
\value{
a dataframe of samples x features
The features are in the form of protein 1 vs protein 2, protein 1 vs protein 3 ...
etc, with the numbers representing the L values.
}
\description{
This function calculates L-statistics to measure spatial autocorrelation.
L value greater than zero indicates spatial attraction of the pair of proteins
whereas L value less than zero indicates spatial repulsion.
The function supports  spatial proteomics and spatial transcriptomics.
}
\examples{

utils::data("example_scrnaseq" , package = "scFeatures")
celltype <- example_scrnaseq$celltype 
data <- example_scrnaseq@assays$RNA@data
sample <- sample( c("patient1", "patient2", "patient3"), ncol(data) , replace= TRUE )
x <- sample(1:100, ncol(data) , replace = TRUE)
y <- sample(1:100, ncol(data) , replace = TRUE)
spatialCoords <- list( x , y)
alldata <- scFeatures:::formatData(data = data, sample = sample, celltype = celltype, 
spatialCoords  = spatialCoords )

feature_L_function <- run_L_function(alldata, type = "spatial_p", ncores = 1)

}
