% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_expression_table.R
\name{filter_expression_table}
\alias{filter_expression_table}
\title{Filter binned expression matrix}
\usage{
filter_expression_table(bined_table, bin_cutoff, as_matrix = FALSE)
}
\arguments{
\item{bined_table}{A \code{tibble}, usually the output of \code{\link{bin_scdata}}.}

\item{bin_cutoff}{the number of the first bin to be filtered out. Can be the
output of \code{\link{determine_bin_cutoff}}).}

\item{as_matrix}{A boolean. Should the return be a \code{tibble} (\code{FALSE}, the default) or
a \code{matrix} (\code{TRUE}).}
}
\value{
A \code{tibble} or a \code{matrix} depending on the value of \code{as_matrix}
}
\description{
Takes a binned expression table (the output of \code{\link{bin_scdata}}), a bin number
(usually the output of \code{\link{determine_bin_cutoff}}) and returned a filtered expression
table or matrix.
}
\examples{
myData <- tibble::data_frame(
    bin = rep(c(1, 2, 3), each = 3),
    mean = 9:1,
    sd = runif(9),
    cv = runif(9),
    cell1 = 8:0 + runif(9),
    cell2 = 8:0 + runif(9)
)
filter_expression_table(myData, bin_cutoff = 2)
filter_expression_table(myData, bin_cutoff = 3)

}
\seealso{
\code{\link{bin_scdata}}, \code{\link{determine_bin_cutoff}}
}
