% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate_windows.R
\name{correlate_windows}
\alias{correlate_windows}
\title{Calculate correlations against top window.}
\usage{
correlate_windows(dataset, n_random = 3, ...)
}
\arguments{
\item{dataset}{A data frame containing all the binned genes. Usually the output of \code{\link{bin_scdata}}.}

\item{n_random}{Number of top window randomization to serve as a negative control. Default to 3.}

\item{...}{Additional arguments to be passed to \code{\link{cor}}. Default method is \code{pearson}
which is the fastest.}
}
\value{
A \code{tibble} containing correlation values.
}
\description{
Calculates pairwise correlations between all features each window against
all features in the reference window.
}
\details{
This function:
\itemize{
     \item correlates each feature in each window to each feature in the
      top window.

\item randomize the top window by shuffling expression value, and
      correlate each gene in each window to the randomized top window.
      This negative control is repeated as many time as specified by
     the \code{n_random} parameter.
}
The input of this function is usually the output of the \code{\link{bin_scdata}} function.
}
\examples{
library(magrittr)
expMat <- matrix(
    c(1, 1, 5,
      1, 2, 3,
      0, 1, 4,
      0, 0, 2),
    ncol = 3, byrow = TRUE, dimnames = list(paste("gene", 1:4), paste("cell", 1:3))
)

calculate_cvs(expMat) \%>\%
    define_top_genes(window_size = 2) \%>\%
    bin_scdata(window_number = 1) \%>\%
    correlate_windows

}
