% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCramerPValue.R
\name{calculateCramerPValue}
\alias{calculateCramerPValue}
\title{Calculate Cramer Test P-Values for Two-Sample Comparison of Multivariate ECDFs}
\usage{
calculateCramerPValue(
  query_data,
  reference_data,
  query_cell_type_col,
  ref_cell_type_col,
  cell_types = NULL,
  pc_subset = 1:5,
  assay_name = "logcounts",
  max_cells_query = 5000,
  max_cells_ref = 5000
)
}
\arguments{
\item{query_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the query cells.}

\item{reference_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the reference cells.}

\item{query_cell_type_col}{The column name in the \code{colData} of \code{query_data} that identifies the cell types.}

\item{ref_cell_type_col}{The column name in the \code{colData} of \code{reference_data} that identifies the cell types.}

\item{cell_types}{A character vector specifying the cell types to include in the plot. If NULL, all cell types are included.}

\item{pc_subset}{A numeric vector specifying which principal components to include in the plot. Default is PC1 to PC5.}

\item{assay_name}{Name of the assay on which to perform computations. Default is "logcounts".}

\item{max_cells_query}{Maximum number of query cells to retain after cell type filtering. If NULL,
no downsampling of query cells is performed. Default is 5000.}

\item{max_cells_ref}{Maximum number of reference cells to retain after cell type filtering. If NULL,
no downsampling of reference cells is performed. Default is 5000.}
}
\value{
A named vector of p-values from the Cramer test for each cell type.
}
\description{
This function performs the Cramer test for comparing multivariate empirical cumulative distribution functions (ECDFs)
between two samples.
}
\details{
The function performs the following steps:
\enumerate{
  \item Projects the data into the PCA space.
  \item Subsets the data to the specified cell types and principal components.
  \item Performs the Cramer test for each cell type using the \code{cramer.test} function in the \code{cramer} package.
}
}
\examples{
# Load data
data("reference_data")
data("query_data")

# Plot the PC data (with query data)
cramer_test <- calculateCramerPValue(reference_data = reference_data,
                                     query_data = query_data,
                                     ref_cell_type_col = "expert_annotation",
                                     query_cell_type_col = "SingleR_annotation",
                                     cell_types = c("CD4", "CD8", "B_and_plasma", "Myeloid"),
                                     pc_subset = 1:5)
cramer_test

}
\references{
Baringhaus, L., & Franz, C. (2004). "On a new multivariate two-sample test".
Journal of Multivariate Analysis, 88(1), 190-206.
}
