% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectCellTypes.R
\name{selectCellTypes}
\alias{selectCellTypes}
\title{Cell Type Selection and Validation for SingleCellExperiment Analysis}
\usage{
selectCellTypes(
  query_data = NULL,
  reference_data = NULL,
  query_cell_type_col = NULL,
  ref_cell_type_col = NULL,
  cell_types = NULL,
  dual_only = FALSE,
  n_cell_types = NULL
)
}
\arguments{
\item{query_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the query cells.
Can be \code{NULL} if only reference data is available.}

\item{reference_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the reference cells.
Can be \code{NULL} if only query data is available.}

\item{query_cell_type_col}{The column name in the \code{colData} of \code{query_data}
that identifies the cell types. Should be \code{NULL} if \code{query_data} is \code{NULL}.}

\item{ref_cell_type_col}{The column name in the \code{colData} of \code{reference_data}
that identifies the cell types. Should be \code{NULL} if \code{reference_data} is \code{NULL}.}

\item{cell_types}{A character vector specifying the cell types to validate. If \code{NULL},
cell types will be automatically selected based on dataset availability and \code{dual_only} setting.}

\item{dual_only}{A logical value indicating whether cell types must be present in both datasets.
If \code{TRUE}, both \code{query_data} and \code{reference_data} must be provided, and only
cell types present in both datasets will be considered. Default is \code{FALSE}.}

\item{n_cell_types}{An integer specifying the maximum number of cell types to select based on
highest cell count. If \code{NULL}, all valid cell types are returned. Default is \code{NULL}.}
}
\value{
A character vector of selected cell types that meet the specified criteria.
}
\description{
This function selects and validates cell types for functions that analyze \code{\linkS4class{SingleCellExperiment}}
objects. It determines which cell types to include based on availability in datasets, applies filtering
criteria, and optionally selects the top cell types by cell count.
}
\details{
The function performs the following selection and validation steps:
\itemize{
 \item Validates that at least one of \code{query_data} or \code{reference_data} is provided.
 \item When \code{dual_only} is TRUE, ensures both datasets are provided.
 \item Determines available cell types based on dataset availability and \code{dual_only} setting.
 \item If \code{cell_types} is NULL and both datasets are available, includes cell types based on \code{dual_only}.
 \item If \code{cell_types} is NULL and only one dataset is available, includes all cell types from that dataset.
 \item If \code{cell_types} is provided, filters to include only valid types.
 \item If \code{n_cell_types} is specified, selects the top cell types by total cell count.
 \item Returns the selected and validated cell types as character strings.
}
}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
\keyword{internal}
