% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_data.R
\name{construct_data}
\alias{construct_data}
\title{Construct the input data (covariate matrix and expression matrix)}
\usage{
construct_data(
  sce,
  assay_use = "counts",
  celltype,
  pseudotime,
  spatial,
  other_covariates,
  ncell = dim(sce)[2],
  corr_by,
  parallelization = "mcmapply",
  BPPARAM = NULL
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object.}

\item{assay_use}{A string which indicates the assay you will use in the sce. Default is 'counts'.}

\item{celltype}{A string of the name of cell type variable in the \code{colData} of the sce. Default is 'cell_type'.}

\item{pseudotime}{A string or a string vector of the name of pseudotime and (if exist)
multiple lineages. Default is NULL.}

\item{spatial}{A length two string vector of the names of spatial coordinates. Default is NULL.}

\item{other_covariates}{A string or a string vector of the other covariates you want to include in the data.}

\item{ncell}{The number of cell you want to simulate. Default is \code{dim(sce)[2]} (the same number as the input data).
If an arbitrary number is provided, the function will use Vine Copula to simulate a new covariate matrix.}

\item{corr_by}{A string or a string vector which indicates the groups for correlation structure. If '1', all cells have one estimated corr. If 'ind', no corr (features are independent). If others, this variable decides the corr structures.}

\item{parallelization}{A string indicating the specific parallelization function to use.
Must be one of 'mcmapply', 'bpmapply', or 'pbmcmapply', which corresponds to the parallelization function in the package
\code{parallel},\code{BiocParallel}, and \code{pbmcapply} respectively. The default value is 'mcmapply'.}

\item{BPPARAM}{A \code{MulticoreParam} object or NULL. When the parameter parallelization = 'mcmapply' or 'pbmcmapply',
this parameter must be NULL. When the parameter parallelization = 'bpmapply',  this parameter must be one of the
\code{MulticoreParam} object offered by the package 'BiocParallel. The default value is NULL.}
}
\value{
A list with the components:
\describe{
  \item{\code{count_mat}}{The expression matrix}
  \item{\code{dat}}{The original covariate matrix}
  \item{\code{newCovariate}}{The simulated new covariate matrix, is NULL if the parameter ncell is default}
  \item{\code{filtered_gene}}{The genes that are excluded in the marginal and copula fitting 
steps because these genes only express in less than two cells.}
}
}
\description{
This function constructs the input data for \code{\link{fit_marginal}}.
}
\details{
This function takes a \code{SingleCellExperiment} object as the input.
Based on users' choice, it constructs the matrix of covariates
(explanatory variables) and the expression matrix (e.g., count matrix for scRNA-seq).
}
\examples{
  data(example_sce)
  my_data <- construct_data(
  sce = example_sce,
  assay_use = "counts",
  celltype = "cell_type",
  pseudotime = "pseudotime",
  spatial = NULL,
  other_covariates = NULL,
  corr_by = "1"
  )


}
